/*
 * Decompiled with CFR 0.152.
 */
package geotrans3.gui;

import geotrans3.exception.CoordinateConversionException;
import geotrans3.misc.FormatOptions;
import geotrans3.misc.StringHandler;
import geotrans3.utility.Platform;
import geotrans3.utility.Utility;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

public class FormatOptionsDlg
extends JDialog {
    private FormatOptions options;
    private FormatOptions origOptions;
    private StringHandler stringHandler = new StringHandler();
    private static int previousHeightUnit = 0;
    private JRadioButton _0_360RangeRadioButton;
    private JRadioButton _100000mPrecisionRadioButton;
    private JRadioButton _10000mPrecisionRadioButton;
    private JRadioButton _1000mPrecisionRadioButton;
    private JRadioButton _100mPrecisionRadioButton;
    private JRadioButton _10mPrecisionRadioButton;
    private JRadioButton _180_180RangeRadioButton;
    private JRadioButton _1mPrecisionRadioButton;
    private JRadioButton __001mPrecisionRadioButton;
    private JRadioButton __01mPrecisionRadioButton;
    private JRadioButton __1mPrecisionRadioButton;
    private JButton applyButton;
    private JPanel applyFormatPanel;
    private JPanel buttonsPanel;
    private JButton cancelButton;
    private JRadioButton colonSeparatorRadioButton;
    private JRadioButton dUnitsRadioButton;
    private JRadioButton dmUnitsRadioButton;
    private JRadioButton dmsUnitsRadioButton;
    private JLabel formatLabel;
    private JTextField formatTextField;
    private JLabel geodeticSeparatorLabel;
    private JLabel geodeticUnitsLabel;
    private JRadioButton hemiRadioButton;
    private JCheckBox leadingZerosCheckBox;
    private JLabel longRangeLabel;
    private JLabel newFormatLabel;
    private JTextField newFormatTextField;
    private JPanel numberFormatPanel;
    private JButton okButton;
    private JTabbedPane optionsTabbedPane;
    private JPanel precisionPanel;
    private JPanel rangePanel;
    private JPanel separatorPanel;
    private JLabel signHemiLabel;
    private JPanel signHemiPanel;
    private JRadioButton signRadioButton;
    private JRadioButton slashSeparatorRadioButton;
    private JRadioButton spaceSeparatorRadioButton;
    private JPanel unitsPanel;
    private JPanel heightElevationPanel;
    private JLabel geodeticHeightUnitLabel;
    private JRadioButton heightMeterRadioButton;
    private JRadioButton heightSurveyFeetRadioButton;
    private JLabel heightMetersUnitLabel;
    private JLabel heightSurveyFeetUnitLabel;
    private JTextArea heightNoteText;

    public FormatOptionsDlg(Frame frame, boolean bl, FormatOptions formatOptions) {
        super(frame, bl);
        this.initComponents();
        this.createButtonGroups();
        this.options = formatOptions;
        this.origOptions = new FormatOptions(formatOptions);
        this.setUnitsButton(formatOptions.getUnits());
        this.setSeparatorButton(formatOptions.getSeparator());
        this.setSignButton(formatOptions.getSignHemi());
        this.setRangeButton(formatOptions.getRange());
        this.setPrecisionButton(formatOptions.getPrecision());
        this.leadingZerosCheckBox.setSelected(formatOptions.getLeadingZeros());
        this.setHeightUnitButton(formatOptions.getHeightUnit());
        this.setFormatString(this.formatTextField);
        this.setFormatString(this.newFormatTextField);
        if (Platform.isJavaV1_3) {
            this.formatLabel.setForeground(Color.black);
            this.newFormatLabel.setForeground(Color.black);
            this.geodeticUnitsLabel.setForeground(Color.black);
            this.geodeticSeparatorLabel.setForeground(Color.black);
            this.signHemiLabel.setForeground(Color.black);
            this.longRangeLabel.setForeground(Color.black);
            this.leadingZerosCheckBox.setForeground(Color.black);
            this.geodeticHeightUnitLabel.setForeground(Color.black);
        }
        this.pack();
        Utility.center(frame, this);
    }

    private void initComponents() {
        this.applyFormatPanel = new JPanel();
        this.formatLabel = new JLabel();
        this.newFormatLabel = new JLabel();
        this.formatTextField = new JTextField();
        this.newFormatTextField = new JTextField();
        this.optionsTabbedPane = new JTabbedPane();
        this.numberFormatPanel = new JPanel();
        this.unitsPanel = new JPanel();
        this.geodeticUnitsLabel = new JLabel();
        this.dmsUnitsRadioButton = new JRadioButton();
        this.dmUnitsRadioButton = new JRadioButton();
        this.dUnitsRadioButton = new JRadioButton();
        this.separatorPanel = new JPanel();
        this.geodeticSeparatorLabel = new JLabel();
        this.spaceSeparatorRadioButton = new JRadioButton();
        this.slashSeparatorRadioButton = new JRadioButton();
        this.colonSeparatorRadioButton = new JRadioButton();
        this.signHemiPanel = new JPanel();
        this.signHemiLabel = new JLabel();
        this.signRadioButton = new JRadioButton();
        this.hemiRadioButton = new JRadioButton();
        this.rangePanel = new JPanel();
        this.longRangeLabel = new JLabel();
        this._180_180RangeRadioButton = new JRadioButton();
        this._0_360RangeRadioButton = new JRadioButton();
        this.leadingZerosCheckBox = new JCheckBox();
        this.precisionPanel = new JPanel();
        this._100000mPrecisionRadioButton = new JRadioButton();
        this._10000mPrecisionRadioButton = new JRadioButton();
        this._1000mPrecisionRadioButton = new JRadioButton();
        this._100mPrecisionRadioButton = new JRadioButton();
        this._10mPrecisionRadioButton = new JRadioButton();
        this._1mPrecisionRadioButton = new JRadioButton();
        this.__1mPrecisionRadioButton = new JRadioButton();
        this.__01mPrecisionRadioButton = new JRadioButton();
        this.__001mPrecisionRadioButton = new JRadioButton();
        this.buttonsPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.applyButton = new JButton();
        this.heightElevationPanel = new JPanel();
        this.geodeticHeightUnitLabel = new JLabel();
        this.heightMeterRadioButton = new JRadioButton();
        this.heightSurveyFeetRadioButton = new JRadioButton();
        this.heightMetersUnitLabel = new JLabel();
        this.heightSurveyFeetUnitLabel = new JLabel();
        this.setTitle("Format");
        this.setName("");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                FormatOptionsDlg.this.dialogWindowClosing(windowEvent);
            }
        });
        this.applyFormatPanel.setLayout(new GridLayout(2, 1, 20, 5));
        this.formatLabel.setFont(new Font("Dialog", 3, 14));
        this.formatLabel.setHorizontalAlignment(0);
        this.formatLabel.setText("Current Format:");
        this.applyFormatPanel.add(this.formatLabel);
        this.newFormatLabel.setFont(new Font("Dialog", 3, 14));
        this.newFormatLabel.setHorizontalAlignment(0);
        this.newFormatLabel.setText("New  Format:");
        this.applyFormatPanel.add(this.newFormatLabel);
        this.formatTextField.setEditable(false);
        this.formatTextField.setHorizontalAlignment(0);
        this.formatTextField.setText("260 30 20.0E");
        this.applyFormatPanel.add(this.formatTextField);
        this.newFormatTextField.setEditable(false);
        this.newFormatTextField.setHorizontalAlignment(0);
        this.newFormatTextField.setText("260 30 20.00");
        this.applyFormatPanel.add(this.newFormatTextField);
        this.getContentPane().add((Component)this.applyFormatPanel, "North");
        this.optionsTabbedPane.setFont(new Font("Dialog", 1, 10));
        this.numberFormatPanel.setLayout(new GridBagLayout());
        this.numberFormatPanel.setBorder(new EtchedBorder());
        this.unitsPanel.setLayout(new GridBagLayout());
        this.unitsPanel.setBorder(new EmptyBorder(new Insets(0, 10, 0, 0)));
        this.unitsPanel.setMinimumSize(new Dimension(170, 86));
        this.unitsPanel.setPreferredSize(new Dimension(170, 86));
        this.geodeticUnitsLabel.setText("Geodetic Units");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.unitsPanel.add((Component)this.geodeticUnitsLabel, gridBagConstraints);
        this.dmsUnitsRadioButton.setFont(new Font("Dialog", 0, 10));
        this.dmsUnitsRadioButton.setSelected(true);
        this.dmsUnitsRadioButton.setText("Degrees / Minutes / Seconds");
        this.dmsUnitsRadioButton.setModel(this.dmsUnitsRadioButton.getModel());
        this.dmsUnitsRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FormatOptionsDlg.this.unitsActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.unitsPanel.add((Component)this.dmsUnitsRadioButton, gridBagConstraints);
        this.dmUnitsRadioButton.setFont(new Font("Dialog", 0, 10));
        this.dmUnitsRadioButton.setText("Degrees / Minutes ");
        this.dmUnitsRadioButton.setModel(this.dmUnitsRadioButton.getModel());
        this.dmUnitsRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FormatOptionsDlg.this.unitsActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.unitsPanel.add((Component)this.dmUnitsRadioButton, gridBagConstraints);
        this.dUnitsRadioButton.setFont(new Font("Dialog", 0, 10));
        this.dUnitsRadioButton.setText("Degrees ");
        this.dUnitsRadioButton.setModel(this.dUnitsRadioButton.getModel());
        this.dUnitsRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FormatOptionsDlg.this.unitsActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.unitsPanel.add((Component)this.dUnitsRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 0, 3, 0);
        gridBagConstraints.anchor = 18;
        this.numberFormatPanel.add((Component)this.unitsPanel, gridBagConstraints);
        this.separatorPanel.setLayout(new GridBagLayout());
        this.separatorPanel.setBorder(new EmptyBorder(new Insets(0, 10, 0, 0)));
        this.separatorPanel.setMinimumSize(new Dimension(150, 86));
        this.separatorPanel.setPreferredSize(new Dimension(125, 86));
        this.geodeticSeparatorLabel.setText("Geodetic Separator");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.separatorPanel.add((Component)this.geodeticSeparatorLabel, gridBagConstraints);
        this.spaceSeparatorRadioButton.setFont(new Font("Dialog", 0, 10));
        this.spaceSeparatorRadioButton.setSelected(true);
        this.spaceSeparatorRadioButton.setText("DD MM SS");
        this.spaceSeparatorRadioButton.setModel(this.spaceSeparatorRadioButton.getModel());
        this.spaceSeparatorRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FormatOptionsDlg.this.separatorActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.separatorPanel.add((Component)this.spaceSeparatorRadioButton, gridBagConstraints);
        this.slashSeparatorRadioButton.setFont(new Font("Dialog", 0, 10));
        this.slashSeparatorRadioButton.setText("DD/MM/SS");
        this.slashSeparatorRadioButton.setModel(this.slashSeparatorRadioButton.getModel());
        this.slashSeparatorRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FormatOptionsDlg.this.separatorActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.separatorPanel.add((Component)this.slashSeparatorRadioButton, gridBagConstraints);
        this.colonSeparatorRadioButton.setFont(new Font("Dialog", 0, 10));
        this.colonSeparatorRadioButton.setText("DD:MM:SS");
        this.colonSeparatorRadioButton.setModel(this.colonSeparatorRadioButton.getModel());
        this.colonSeparatorRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FormatOptionsDlg.this.separatorActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.separatorPanel.add((Component)this.colonSeparatorRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 5, 3, 6);
        gridBagConstraints.anchor = 12;
        this.numberFormatPanel.add((Component)this.separatorPanel, gridBagConstraints);
        this.signHemiPanel.setLayout(new GridBagLayout());
        this.signHemiPanel.setBorder(new EmptyBorder(new Insets(0, 10, 0, 0)));
        this.signHemiPanel.setMinimumSize(new Dimension(149, 68));
        this.signHemiPanel.setPreferredSize(new Dimension(119, 68));
        this.signHemiLabel.setHorizontalAlignment(2);
        this.signHemiLabel.setText("Sign /  Hemisphere");
        this.signHemiLabel.setHorizontalTextPosition(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.signHemiPanel.add((Component)this.signHemiLabel, gridBagConstraints);
        this.signRadioButton.setFont(new Font("Dialog", 0, 10));
        this.signRadioButton.setText("+ / -");
        this.signRadioButton.setHorizontalAlignment(2);
        this.signRadioButton.setModel(this.signRadioButton.getModel());
        this.signRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FormatOptionsDlg.this.signHemiActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.signHemiPanel.add((Component)this.signRadioButton, gridBagConstraints);
        this.hemiRadioButton.setFont(new Font("Dialog", 0, 10));
        this.hemiRadioButton.setSelected(true);
        this.hemiRadioButton.setText("N / S, E / W");
        this.hemiRadioButton.setHorizontalAlignment(2);
        this.hemiRadioButton.setModel(this.hemiRadioButton.getModel());
        this.hemiRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FormatOptionsDlg.this.signHemiActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        this.signHemiPanel.add((Component)this.hemiRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        gridBagConstraints.anchor = 18;
        this.numberFormatPanel.add((Component)this.signHemiPanel, gridBagConstraints);
        this.rangePanel.setLayout(new GridBagLayout());
        this.rangePanel.setBorder(new EmptyBorder(new Insets(0, 10, 0, 0)));
        this.rangePanel.setMinimumSize(new Dimension(119, 88));
        this.rangePanel.setPreferredSize(new Dimension(110, 68));
        this.longRangeLabel.setText("Longitude Range");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.rangePanel.add((Component)this.longRangeLabel, gridBagConstraints);
        this._180_180RangeRadioButton.setFont(new Font("Dialog", 0, 10));
        this._180_180RangeRadioButton.setSelected(true);
        this._180_180RangeRadioButton.setText("( -180, 180 )");
        this._180_180RangeRadioButton.setModel(this._180_180RangeRadioButton.getModel());
        this._180_180RangeRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FormatOptionsDlg.this.rangeActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.rangePanel.add((Component)this._180_180RangeRadioButton, gridBagConstraints);
        this._0_360RangeRadioButton.setFont(new Font("Dialog", 0, 10));
        this._0_360RangeRadioButton.setText("( 0, 360 )");
        this._0_360RangeRadioButton.setModel(this._0_360RangeRadioButton.getModel());
        this._0_360RangeRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FormatOptionsDlg.this.rangeActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        this.rangePanel.add((Component)this._0_360RangeRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 5, 3, 20);
        gridBagConstraints.anchor = 14;
        this.numberFormatPanel.add((Component)this.rangePanel, gridBagConstraints);
        this.leadingZerosCheckBox.setText("Leading Zeros");
        this.leadingZerosCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FormatOptionsDlg.this.leadingZerosCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 11, 6, 0);
        gridBagConstraints.anchor = 16;
        this.numberFormatPanel.add((Component)this.leadingZerosCheckBox, gridBagConstraints);
        this.optionsTabbedPane.addTab("Number Format", null, this.numberFormatPanel, "");
        this.precisionPanel.setLayout(new GridLayout(9, 1));
        this.precisionPanel.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(new Insets(0, 10, 0, 0))));
        this._100000mPrecisionRadioButton.setFont(new Font("Dialog", 0, 10));
        this._100000mPrecisionRadioButton.setText("100,000m  1 Degree");
        this._100000mPrecisionRadioButton.setModel(this._100000mPrecisionRadioButton.getModel());
        this._100000mPrecisionRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FormatOptionsDlg.this.precisionActionPerformed(actionEvent);
            }
        });
        this.precisionPanel.add(this._100000mPrecisionRadioButton);
        this._10000mPrecisionRadioButton.setFont(new Font("Dialog", 0, 10));
        this._10000mPrecisionRadioButton.setText("10,000m    10 Minutes");
        this._10000mPrecisionRadioButton.setModel(this._10000mPrecisionRadioButton.getModel());
        this._10000mPrecisionRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FormatOptionsDlg.this.precisionActionPerformed(actionEvent);
            }
        });
        this.precisionPanel.add(this._10000mPrecisionRadioButton);
        this._1000mPrecisionRadioButton.setFont(new Font("Dialog", 0, 10));
        this._1000mPrecisionRadioButton.setText("1000m       1 Minute");
        this._1000mPrecisionRadioButton.setModel(this._1000mPrecisionRadioButton.getModel());
        this._1000mPrecisionRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FormatOptionsDlg.this.precisionActionPerformed(actionEvent);
            }
        });
        this.precisionPanel.add(this._1000mPrecisionRadioButton);
        this._100mPrecisionRadioButton.setFont(new Font("Dialog", 0, 10));
        this._100mPrecisionRadioButton.setText("100m         10 Seconds");
        this._100mPrecisionRadioButton.setModel(this._100mPrecisionRadioButton.getModel());
        this._100mPrecisionRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FormatOptionsDlg.this.precisionActionPerformed(actionEvent);
            }
        });
        this.precisionPanel.add(this._100mPrecisionRadioButton);
        this._10mPrecisionRadioButton.setFont(new Font("Dialog", 0, 10));
        this._10mPrecisionRadioButton.setText("10m           1 Second");
        this._10mPrecisionRadioButton.setModel(this._10mPrecisionRadioButton.getModel());
        this._10mPrecisionRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FormatOptionsDlg.this.precisionActionPerformed(actionEvent);
            }
        });
        this.precisionPanel.add(this._10mPrecisionRadioButton);
        this._1mPrecisionRadioButton.setFont(new Font("Dialog", 0, 10));
        this._1mPrecisionRadioButton.setSelected(true);
        this._1mPrecisionRadioButton.setText("1m             0.1 Second");
        this._1mPrecisionRadioButton.setModel(this._1mPrecisionRadioButton.getModel());
        this._1mPrecisionRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FormatOptionsDlg.this.precisionActionPerformed(actionEvent);
            }
        });
        this.precisionPanel.add(this._1mPrecisionRadioButton);
        this.__1mPrecisionRadioButton.setFont(new Font("Dialog", 0, 10));
        this.__1mPrecisionRadioButton.setText("0.1m          0.01 Second");
        this.__1mPrecisionRadioButton.setModel(this.__1mPrecisionRadioButton.getModel());
        this.__1mPrecisionRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FormatOptionsDlg.this.precisionActionPerformed(actionEvent);
            }
        });
        this.precisionPanel.add(this.__1mPrecisionRadioButton);
        this.__01mPrecisionRadioButton.setFont(new Font("Dialog", 0, 10));
        this.__01mPrecisionRadioButton.setText("0.01m        0.001 Second");
        this.__01mPrecisionRadioButton.setModel(this.__01mPrecisionRadioButton.getModel());
        this.__01mPrecisionRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FormatOptionsDlg.this.precisionActionPerformed(actionEvent);
            }
        });
        this.precisionPanel.add(this.__01mPrecisionRadioButton);
        this.__001mPrecisionRadioButton.setFont(new Font("Dialog", 0, 10));
        this.__001mPrecisionRadioButton.setText("0.001m      0.0001 Second");
        this.__001mPrecisionRadioButton.setModel(this.__001mPrecisionRadioButton.getModel());
        this.__001mPrecisionRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FormatOptionsDlg.this.precisionActionPerformed(actionEvent);
            }
        });
        this.precisionPanel.add(this.__001mPrecisionRadioButton);
        this.optionsTabbedPane.addTab("Precision", null, this.precisionPanel, "");
        this.getContentPane().add((Component)this.optionsTabbedPane, "Center");
        this.buttonsPanel.setLayout(new GridBagLayout());
        this.buttonsPanel.setMinimumSize(new Dimension(204, 41));
        this.buttonsPanel.setPreferredSize(new Dimension(204, 41));
        this.okButton.setMnemonic(79);
        this.okButton.setText("OK");
        this.okButton.setBorder(new BevelBorder(0));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FormatOptionsDlg.this.okActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 55;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 25);
        this.buttonsPanel.add((Component)this.okButton, gridBagConstraints);
        this.cancelButton.setMnemonic(67);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setBorder(new BevelBorder(0));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FormatOptionsDlg.this.cancelActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 30;
        this.buttonsPanel.add((Component)this.cancelButton, gridBagConstraints);
        this.applyButton.setMnemonic(65);
        this.applyButton.setText("Apply");
        this.applyButton.setBorder(new BevelBorder(0));
        this.applyButton.setSelected(true);
        this.applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FormatOptionsDlg.this.applyActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 30;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 25, 0, 0);
        this.buttonsPanel.add((Component)this.applyButton, gridBagConstraints);
        this.getContentPane().add((Component)this.buttonsPanel, "South");
        this.heightElevationPanel.setLayout(null);
        this.heightElevationPanel.add(this.geodeticHeightUnitLabel);
        this.geodeticHeightUnitLabel.setText("Geodetic Height Units");
        this.geodeticHeightUnitLabel.setBounds(10, 5, 150, 20);
        this.heightElevationPanel.add(this.heightMeterRadioButton);
        this.heightMeterRadioButton.setFont(new Font("Dialog", 0, 10));
        this.heightMeterRadioButton.setText("Meters");
        this.heightMeterRadioButton.setBounds(10, 28, 57, 20);
        this.heightMeterRadioButton.setModel(this.heightMeterRadioButton.getModel());
        this.heightElevationPanel.add(this.heightMetersUnitLabel);
        this.heightMetersUnitLabel.setFont(new Font("Dialog", 0, 10));
        this.heightMetersUnitLabel.setText("(m)");
        this.heightMetersUnitLabel.setBounds(67, 28, 20, 20);
        this.heightElevationPanel.add(this.heightSurveyFeetRadioButton);
        this.heightSurveyFeetRadioButton.setFont(new Font("Dialog", 0, 10));
        this.heightSurveyFeetRadioButton.setText("U.S. Survey Feet");
        this.heightSurveyFeetRadioButton.setBounds(10, 51, 105, 20);
        this.heightSurveyFeetRadioButton.setModel(this.heightSurveyFeetRadioButton.getModel());
        this.heightElevationPanel.add(this.heightSurveyFeetUnitLabel);
        this.heightSurveyFeetUnitLabel.setFont(new Font("Dialog", 2, 10));
        this.heightSurveyFeetUnitLabel.setText("(ft)");
        this.heightSurveyFeetUnitLabel.setBounds(115, 51, 20, 20);
        this.optionsTabbedPane.addTab("Height / Elevation", null, this.heightElevationPanel, "");
    }

    private void leadingZerosCheckBoxActionPerformed(ActionEvent actionEvent) {
        if (this.leadingZerosCheckBox.isSelected()) {
            this.options.setLeadingZeros(true);
        } else {
            this.options.setLeadingZeros(false);
        }
    }

    private void dialogWindowClosing(WindowEvent windowEvent) {
        this.options.reset(this.origOptions);
        this.setVisible(false);
        this.dispose();
    }

    private void applyActionPerformed(ActionEvent actionEvent) {
        this.setFormatString(this.newFormatTextField);
    }

    private void cancelActionPerformed(ActionEvent actionEvent) {
        this.options.reset(this.origOptions);
        this.setVisible(false);
        this.dispose();
    }

    private void okActionPerformed(ActionEvent actionEvent) {
        previousHeightUnit = this.options.getHeightUnit();
        if (this.heightMeterRadioButton.isSelected()) {
            this.options.setHeightUnit(0);
        } else if (this.heightSurveyFeetRadioButton.isSelected()) {
            this.options.setHeightUnit(1);
        }
        if (this.heightUnitChange()) {
            String string = "Height units were changed.\nPlease reselect Projection to refresh Height units.";
            this.stringHandler.displayWarningMsg(this, string);
        }
        this.setVisible(false);
        this.dispose();
    }

    private void precisionActionPerformed(ActionEvent actionEvent) {
        if (this._100000mPrecisionRadioButton.isSelected()) {
            this.options.setPrecision(0);
        } else if (this._10000mPrecisionRadioButton.isSelected()) {
            this.options.setPrecision(1);
        } else if (this._1000mPrecisionRadioButton.isSelected()) {
            this.options.setPrecision(2);
        } else if (this._100mPrecisionRadioButton.isSelected()) {
            this.options.setPrecision(3);
        } else if (this._10mPrecisionRadioButton.isSelected()) {
            this.options.setPrecision(4);
        } else if (this._1mPrecisionRadioButton.isSelected()) {
            this.options.setPrecision(5);
        } else if (this.__1mPrecisionRadioButton.isSelected()) {
            this.stringHandler.displayWarningMsg(this, "Warning:  Output accuracy is limited to ~1m");
            this.options.setPrecision(6);
        } else if (this.__01mPrecisionRadioButton.isSelected()) {
            this.stringHandler.displayWarningMsg(this, "Warning:  Output accuracy is limited to ~1m");
            this.options.setPrecision(7);
        } else if (this.__001mPrecisionRadioButton.isSelected()) {
            this.stringHandler.displayWarningMsg(this, "Warning:  Output accuracy is limited to ~1m");
            this.options.setPrecision(8);
        }
    }

    private void rangeActionPerformed(ActionEvent actionEvent) {
        if (this._180_180RangeRadioButton.isSelected()) {
            this.options.setRange(0);
        } else if (this._0_360RangeRadioButton.isSelected()) {
            this.options.setRange(1);
        }
    }

    private void signHemiActionPerformed(ActionEvent actionEvent) {
        if (this.signRadioButton.isSelected()) {
            this.options.setSignHemi(0);
        } else if (this.hemiRadioButton.isSelected()) {
            this.options.setSignHemi(1);
        }
    }

    private void separatorActionPerformed(ActionEvent actionEvent) {
        if (this.spaceSeparatorRadioButton.isSelected()) {
            this.options.setSeparator(' ');
        } else if (this.slashSeparatorRadioButton.isSelected()) {
            this.options.setSeparator('/');
        } else if (this.colonSeparatorRadioButton.isSelected()) {
            this.options.setSeparator(':');
        }
    }

    private void unitsActionPerformed(ActionEvent actionEvent) {
        if (this.dmsUnitsRadioButton.isSelected()) {
            this.options.setUnits(0);
        } else if (this.dmUnitsRadioButton.isSelected()) {
            this.options.setUnits(1);
        } else if (this.dUnitsRadioButton.isSelected()) {
            this.options.setUnits(2);
        }
    }

    public boolean heightUnitChange() {
        return previousHeightUnit != this.options.getHeightUnit();
    }

    private void setUnitsButton(int n) {
        if (n == 0) {
            this.dmsUnitsRadioButton.setSelected(true);
        } else if (n == 1) {
            this.dmUnitsRadioButton.setSelected(true);
        } else if (n == 2) {
            this.dUnitsRadioButton.setSelected(true);
        }
    }

    private void setSeparatorButton(int n) {
        if (n == 32) {
            this.spaceSeparatorRadioButton.setSelected(true);
        } else if (n == 47) {
            this.slashSeparatorRadioButton.setSelected(true);
        } else if (n == 58) {
            this.colonSeparatorRadioButton.setSelected(true);
        }
    }

    private void setSignButton(int n) {
        if (n == 0) {
            this.signRadioButton.setSelected(true);
        } else if (n == 1) {
            this.hemiRadioButton.setSelected(true);
        }
    }

    private void setRangeButton(int n) {
        if (n == 1) {
            this._0_360RangeRadioButton.setSelected(true);
        } else if (n == 0) {
            this._180_180RangeRadioButton.setSelected(true);
        }
    }

    private void setHeightUnitButton(int n) {
        if (n == 0) {
            this.heightMeterRadioButton.setSelected(true);
        } else if (n == 1) {
            this.heightSurveyFeetRadioButton.setSelected(true);
        }
    }

    private void setPrecisionButton(int n) {
        if (n == 0) {
            this._100000mPrecisionRadioButton.setSelected(true);
        } else if (n == 1) {
            this._10000mPrecisionRadioButton.setSelected(true);
        } else if (n == 2) {
            this._1000mPrecisionRadioButton.setSelected(true);
        } else if (n == 3) {
            this._100mPrecisionRadioButton.setSelected(true);
        } else if (n == 4) {
            this._10mPrecisionRadioButton.setSelected(true);
        } else if (n == 5) {
            this._1mPrecisionRadioButton.setSelected(true);
        } else if (n == 6) {
            this.__1mPrecisionRadioButton.setSelected(true);
        } else if (n == 7) {
            this.__01mPrecisionRadioButton.setSelected(true);
        } else if (n == 8) {
            this.__001mPrecisionRadioButton.setSelected(true);
        }
    }

    private void setFormatString(JTextField jTextField) {
        try {
            this.stringHandler.setPrecision(this.options.getPrecision());
            this.stringHandler.setLeadingZeros(this.options.getLeadingZeros());
            this.stringHandler.setSeparator(this.options.getSeparator());
            this.stringHandler.setLonRange(this.options.getRange());
            String string = this.stringHandler.longitudeToString(260.50555555555553, this.options.getUseNSEW(), this.options.getUseMinutes(), this.options.getUseSeconds());
            jTextField.setText(string);
        }
        catch (CoordinateConversionException coordinateConversionException) {
            this.stringHandler.displayErrorMsg(this, coordinateConversionException.getMessage());
        }
    }

    public void createButtonGroups() {
        ButtonGroup buttonGroup = new ButtonGroup();
        ButtonGroup buttonGroup2 = new ButtonGroup();
        ButtonGroup buttonGroup3 = new ButtonGroup();
        ButtonGroup buttonGroup4 = new ButtonGroup();
        ButtonGroup buttonGroup5 = new ButtonGroup();
        ButtonGroup buttonGroup6 = new ButtonGroup();
        buttonGroup.add(this.dmsUnitsRadioButton);
        buttonGroup.add(this.dmUnitsRadioButton);
        buttonGroup.add(this.dUnitsRadioButton);
        buttonGroup2.add(this.spaceSeparatorRadioButton);
        buttonGroup2.add(this.slashSeparatorRadioButton);
        buttonGroup2.add(this.colonSeparatorRadioButton);
        buttonGroup3.add(this.signRadioButton);
        buttonGroup3.add(this.hemiRadioButton);
        buttonGroup4.add(this._180_180RangeRadioButton);
        buttonGroup4.add(this._0_360RangeRadioButton);
        buttonGroup5.add(this._100000mPrecisionRadioButton);
        buttonGroup5.add(this._10000mPrecisionRadioButton);
        buttonGroup5.add(this._1000mPrecisionRadioButton);
        buttonGroup5.add(this._100mPrecisionRadioButton);
        buttonGroup5.add(this._10mPrecisionRadioButton);
        buttonGroup5.add(this._1mPrecisionRadioButton);
        buttonGroup5.add(this.__1mPrecisionRadioButton);
        buttonGroup5.add(this.__01mPrecisionRadioButton);
        buttonGroup5.add(this.__001mPrecisionRadioButton);
        buttonGroup6.add(this.heightMeterRadioButton);
        buttonGroup6.add(this.heightSurveyFeetRadioButton);
    }

    public static void main(String[] stringArray) {
    }
}

